///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//										
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//										
//	Avalanche Technology Inc., Proprietary and Confidential	   *
//										
// 	Release:  3.0    Date 6/7/2023  	
//							
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS3001316/AS3004316/AS3008316/AS3016316/AS3032316/AS3064316
//
//  Description: 1/4/8/16/32/64 MEGABIT PARALLEL PERSISTENT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : Tasks for Testing
//
////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
// TASKS DECLARATION                                                            //
////////////////////////////////////////////////////////////////////////////////////

`timescale 1ns/1ps

////////////////////////////////////////////////////////////////////
// Datasheet Timing
////////////////////////////////////////////////////////////////////
specify
  specparam tSLE = 5000;
  specparam tSLEX = 5000;
  specparam tAVWL = 8;
  specparam tWLWH = 25;
  specparam tDVWH = 15;
  specparam tWHAX = 15;
  specparam tELQX = 15; 
  specparam tGLQX = 0; 
  specparam tGLQV = 25; 
  specparam tEHQZ = 5; 
endspecify

////////////////////////////////////////////////////////////////////
//Signals Enable/Disable
////////////////////////////////////////////////////////////////////
task SelectChip;
  begin
    En = 0;
  end
endtask


task DeSelChip;
  begin
    En = 1;
    #5;
  end
endtask


task WriteEnable;
  begin
    Wn = 0;
  end
endtask


task WriteDisable;
  begin
    Wn = 1;
  end
endtask

task OutputEnable;
  begin
    Gn = 0;
  end
endtask 


task OutputDisable;
  begin
    Gn = 1;
  end
endtask

////////////////////////////////////////////////////////////////////
// Send Address
////////////////////////////////////////////////////////////////////
task SendAdd;
input [21:0] addr;

  begin
    ADDR = addr;
  end
endtask


////////////////////////////////////////////////////////////////////
// Send and Receive Data
////////////////////////////////////////////////////////////////////
task SendDataWord;
input [15:0] data;
  begin
    out_en = 1;
    DQ_reg = data;
  end
endtask

task RcvDataWord;
output [15:0] data;
  begin
    #1; // delay by 1ns
    out_en = 0;
    DQ_reg = 32'hz;
    data = DQ;
    //$display("[DEBUG] RcvDataWord() time: %t", $time);
  end
endtask


////////////////////////////////////////////////////////////////////
// WRITE
////////////////////////////////////////////////////////////////////
task Write;
input bit [21:0] addr;
input bit [15:0] data;

begin

  parameter CE_WRITE = 0;

  if( CE_WRITE == 1)
  SelectChip();

  SendAdd(addr);
  OutputDisable();
  #(tAVWL);
  WriteEnable();
  SendDataWord(data);
  #(tWLWH);

  WriteDisable();
  #tWHAX;

  if( CE_WRITE == 1)
  DeSelChip();

  out_en = 0;
end
endtask

////////////////////////////////////////////////////////////////////
// READ
////////////////////////////////////////////////////////////////////
task Read;
input bit [21:0] addr;
input bit [15:0] data;

reg [15:0] data_rcv;

begin

  parameter CE_READ = 0;
  parameter ADR_READ = 0;

  if( CE_READ == 1)
    SelectChip();
  else if (ADR_READ == 1)
    OutputEnable();

  SendAdd(addr);
  WriteDisable();
  #(tELQX-tGLQX);
  OutputEnable();


  #(tGLQV);
  RcvDataWord(data_rcv);

  #(tEHQZ);
  if (ADR_READ == 0)
    OutputDisable();

  if( CE_READ == 1)
  DeSelChip();


  if(data_rcv !== data)
    $display("[ERROR] Mem Read Compare Error: Expected %x Received %x",data,data_rcv);
  else
    $display("[INFO] Mem Read Compare Pass: Expected %x Received %x",data,data_rcv);

end
endtask





////////////////////////////////////////////////////////////////////
// WRITE READ CHECK
////////////////////////////////////////////////////////////////////
task WriteReadCheck();
begin
  $display("*****************************************");
  $display(" Write Read Word Check");
  $display("*****************************************");


  SelectChip();
  Write(22'h01,16'ha864);
  Write(22'h02,16'h9510);
  Write(22'h03,16'h47c4);
  Write(22'h04,16'hfe89);
  Write(22'h05,16'h147a);
  Write(22'h06,16'hce83);
  DeSelChip();


  SelectChip();
  Read(22'h01,16'ha864);
  Read(22'h02,16'h9510);
  Read(22'h03,16'h47c4);
  Read(22'h04,16'hfe89);
  Read(22'h05,16'h147a);
  Read(22'h06,16'hce83);
  DeSelChip();

end
endtask


////////////////////////////////////////////////////////////////////
// Read Memory, Specified timing 
////////////////////////////////////////////////////////////////////
task ReadRelTime;
  input [21:0] addr;
  input [15:0] data;
  input [7:0] dly_addr_el;
  input [7:0] dly_el_gl;
  input [7:0] dly_gl_gh;
  input [7:0] dly_gh_eh;
  input [7:0] dly_eh_addr;

  reg [15:0] data_rcv; 
  begin
    ADDR = addr;
    En = 1'b1;
    Gn = 1'b1;
    Wn = 1'b1;
    out_en = 0;
    #(dly_addr_el);
    En = 0;
    #(dly_el_gl);
    Gn = 0;
    #(dly_gl_gh);
    Gn = 1'b1;
    //data_rcv = DQ;
    #(dly_gh_eh);
    En = 1'b1;
    #(dly_eh_addr);
    data_rcv = DQ;
    $display("[INFO] Mem Read Addr 0x%X: Expected 0x%X Received 0x%X",addr,data,data_rcv);
  end
endtask

////////////////////////////////////////////////////////////////////
// Write Memory, Specified timing 
////////////////////////////////////////////////////////////////////
task WriteRelTime;
  input [21:0] addr;
  input [15:0] data;
  input [7:0] dly_addr_el;
  input [7:0] dly_el_wl;
  input [7:0] dly_wl_dq;
  input [7:0] dly_dq_wh;
  input [7:0] dly_wh_eh;
  input [7:0] dly_eh_addr;
  begin
    ADDR = addr;
    En = 1'b1;
    Gn = 1'b1;
    Wn = 1'b1;
    #(dly_addr_el);
    En = 0;
    #(dly_el_wl);
    Wn = 0;
    #(dly_wl_dq);
    out_en = 1'b1;
    DQ_reg = data;
    #(dly_dq_wh);
    Wn = 1'b1;
    #(dly_wh_eh);
    out_en = 0;
    DQ_reg = 0;
    En = 1'b1;
    #(dly_eh_addr);

  end
endtask

////////////////////////////////////////////////////////////////////
// Read Memory, Specified timing, Enable triggered
////////////////////////////////////////////////////////////////////
task ReadRelTimeEnTrig;
  input [21:0] addr;
  input [15:0] data;
  input [7:0] dly_addr_gl;
  input [7:0] dly_gl_el;
  input [7:0] dly_gl_gh;
  input [7:0] dly_gh_eh;
  input [7:0] dly_eh_addr;

  reg [15:0] data_rcv; 
  begin
    ADDR = addr;
    En = 1'b1;
    Gn = 1'b1;
    Wn = 1'b1;
    out_en = 0;
    #(dly_addr_gl);
    Gn = 0;
    #(dly_gl_el);
    En = 0;
    #(dly_gl_gh);
    Gn = 1'b1;
    //data_rcv = DQ;
    #(dly_gh_eh);
    En = 1'b1;
    #(dly_eh_addr);
    data_rcv = DQ;
    $display("[INFO] Mem Read Addr 0x%X: Expected 0x%X Received 0x%X",addr,data,data_rcv);
  end
endtask
